<html>
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title>Register_First</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/css/layui.min.css">
    <link rel="stylesheet" href="/public/site/layui/css/layui.css">
    <link rel="stylesheet" href="/public/site/css/common.css">
  </head>
  <body class="login_body">
    <div class="login_bg">
      <div class="main">
        <p style="font-family: Arial, Arial;font-weight: 700;font-size: 30px;color: #FFFFFF;margin-top:20px;margin-left:20px;">Welcome to register</p>
        <div class="login_form position">
          <form action="{{url('register')}}" method="post" class="register-form">
            @csrf
            <for class="layui-form layui-form-pane" style="padding-top: 40px">
              <div class="form_container">
                <div class="label">
                  Mobile phone number
                </div>
                <div class="layui-form-item">
                  <label class="layui-form-label">+27</label>
                  <div class="layui-input-block">
                    <div class="layui-input-wrap">
                      <input type="text" name="phone" style="border-top-right-radius: 100px;border-bottom-right-radius: 100px" value="" lay-verify="required" placeholder="Please enter your phone number" autocomplete="off" class="layui-input" lay-affix="clear" required>
                      <div class="layui-input-affix layui-input-suffix layui-hide">
                        <i class="layui-icon layui-icon-clear"></i>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="label">
                  Password
                </div>
                <div class="layui-form-item">
                  <div class="layui-input-wrap">
                    <input type="password" style="border-radius: 100px;" name="password" value="" lay-verify="required" placeholder="Please enter password" autocomplete="off" class="layui-input" lay-affix="eye" required>
                    <div class="layui-input-affix layui-input-suffix">
                      <i class="layui-icon layui-icon-eye-invisible"></i>
                    </div>
                  </div>
                </div>
                <div class="label">
                  Invitation Code
                </div>
                <div class="layui-form-item">
                  <div class="layui-input-wrap">
                    <input type="text" style="border-radius: 100px;" name="ref_by" value="{{isset($ref_by) && !empty($ref_by) && $ref_by != null ? $ref_by : rand(0,99999999)}}" lay-verify="required" placeholder="Please enter Invitation Code" autocomplete="off" class="layui-input" required>
                  </div>
                </div>
                <div class="label">
                  Verification code (OTP)
                </div>
                <div class="layui-form-item">
                  <div class="layui-row" style="background: none">
                    <div class="layui-col-xs8">
                      <div class="layui-input-wrap border_noe">
                        <input type="number" style="border-top-left-radius: 100px;border-bottom-left-radius: 100px" name="code" id="code" lay-verify="required" placeholder="Verification code" autocomplete="off" class="layui-input border_noe" required>
                      </div>
                    </div>
                    <div class="layui-col-xs4">
                      <div style="margin-left: 11px;">
                        <div onclick="getOtp()" class="layui-btn layui-btn-fluid layui-btn-primary" style="color: #1A53CF ;border: none;line-height: 50px;" name="otp">
                          Send
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div style="margin-top: 40px">
                  <button class="layui-btn layui-btn-lg layui-btn-fluid layui-btn-radius login_btn" lay-submit="" lay-filter="register">Register Now</button>
                </div>
              </div>
            </form>
          </div>
          <div style="background: rgba(255,255,255,0.8);border-radius: 0px 0px 16px 16px;margin: 0 30px;padding: 15px;text-align: center">
            <a href="{{url('login')}}" style="font-family: Arial, Arial;font-weight: 400;font-size: 16px;color: #888888;">Existing account? <span style="color:#138140;font-weight: 700">Sign up</span></a>
          </div>
        </div>
      </div>
      <!-- Loading animation overlay (hidden by default) -->
      <div class="loadingClass" style="display: none;">
        <div class="spinner"></div>
        <p>Success...</p>
      </div>

      <!-- Include additional components like loading animation and alert messages -->
      @include('loading')
      @include('alert-message')

      <style>
        /* Loading animation styles */
        .loadingClass {
          display: flex;
          flex-direction: column;
          align-items: center;
          justify-content: center;
          position: fixed;
          top: 0;
          left: 0;
          width: 100%;
          height: 100%;
          background: rgba(0, 0, 0, 0.5);
          color: #fff;
          font-size: 18px;
          z-index: 9999;
        }

        /* Spinner style */
        .spinner {
          width: 40px;
          height: 40px;
          border: 4px solid #fff;
          border-top: 4px solid transparent;
          border-radius: 50%;
          animation: spin 0.8s linear infinite;
          margin-bottom: 15px;
        }

        /* Keyframe animation for spinner */
        @keyframes spin {
          0% { transform: rotate(0deg); }
          100% { transform: rotate(360deg); }
        }
      </style>

      <script>
        /* Register user function with validation checks */
        function registerUser() {
          document.querySelector('.loadingClass').style.display = 'flex';

          // Validate phone number
          if (document.querySelector('input[name="phone"]').value == '') {
            message('Please enter your phone number');
            document.querySelector('.loadingClass').style.display = 'none';
            return;
          }

          // Validate OTP
          if (document.querySelector('input[name="otp"]').value == '') {
            message('Please enter the OTP');
            document.querySelector('.loadingClass').style.display = 'none';
            return;
          }

          // Check if OTP is correct (this should ideally be verified server-side)
          var generatedOtp = document.querySelector('input[name="otp"]').value;
          if (generatedOtp !== '1234') { // Replace with actual OTP validation
            message('Incorrect OTP');
            document.querySelector('.loadingClass').style.display = 'none';
            return;
          }

          // Submit the registration form
          document.querySelector('.register-form').submit();
        }

        /* Function to simulate OTP sending and populating the OTP field */
        function getOtp() {
          if (document.querySelector('input[name="phone"]').value == '') {
            message('Please enter a phone number');
            return;
          }

          // Show loading animation
          document.querySelector('.loadingClass').style.display = 'flex';

          // Simulate OTP sending and receiving
          setTimeout(function (){
            document.querySelector('.loadingClass').style.display = 'none';
            var otp = generateOtp(); // Generate a random OTP
            document.querySelector('input[name="code"]').value = otp; // Insert the OTP in the code field
            message('OTP sent: ' + otp); // Notify the user with the OTP (you can remove this line in production)
          }, 1000);
        }

        /* Function to generate a random OTP */
        function generateOtp() {
          return Math.floor(1000 + Math.random() * 9000); // Generates a 4-digit OTP
        }

        /* Message display function for error handling */
        function message(msg) {
          message(msg); // Display the error message
        }
      </script>
    </div>
  </body>
</html>